**************************************************************************************************************************************************
******************* Code for 'Does monetary policy affect non-mining business investment in Australia? evidence from BLADE' *******************
***********************************************************************************************************************

**************************************************DATE: 27 Nov 2023 ******************************************************************************
**************************************************** AUTHOR: Gulnara Nolan and Jonathan Hambur *******************************************************************
*********************************************************************************************************************************************

*** Code strcuture


*01 Investment stats
*02 Delator



cd "$intermediate"
use bas_final3.dta, clear



tsset firmid2 period




****** 01 Investment stats - 
************Table 1
****producing stats for investment if previous investment was zero

tabstat intmargin if l.capex==0 & capex>0 , by(tsid) stat (N mean min max)

tabstat capex if l.capex==0 & capex>0 , by(tsid) stat (N mean min max)

****producing stats for investment if previous investment was positive and not equal to zero

tabstat intmargin if l.capex>0 & capex>0 , by(tsid) stat (N mean min max)

tabstat capex if l.capex>0 & capex>0 , by(tsid) stat (N mean min max)

***producing stats for investment if investment is always positive and not equal to zero

tabstat intmargin if capex>0 , by(tsid) stat (N mean min max)

tabstat capex if capex>0 , by(tsid) stat (N mean min max)


**** finding second max for clearance
egen maxcapex=max(capex) if lcapex==0 & capex>0, by(tsid)

preserve 
drop if capex==maxcapex
drop maxcapex
egen maxcapex=max(capex) if lcapex==0 & capex>0, by(tsid)
tabstat maxcapex, by (tsid) stats (mean max min)
tabstat maxcapex, by (tsid) stats (mean)

restore 

****tracking Zero investment over time

tabstat extmargin if extmargin==0, by(tsid) stat (N)
bys fsize_: tab extmargin
tabstat firmid2 , by(ind) stat (N)

tabstat capex if l.capex==0 & capex>0 , by(period) stat (N mean min max)
tabstat capex if capex>0 , by(period) stat (N mean min max)

*02 Deflator
**** setting up investment price deflator
***********************************************************************
gen qdate=yq(tsid,qr)
format qdate %tq
gen deflator=.
replace deflator=1.02 if period==8009
replace deflator=1.01 if period==8010
replace deflator=1.01 if period==8011
replace deflator=1.02 if period==8012
replace deflator=1.01 if period==8013
replace deflator=1.00 if period==8014
replace deflator=0.99 if period==8015
replace deflator=0.97 if period==8016
replace deflator=0.96 if period==8017
replace deflator=0.96 if period==8018
replace deflator=0.96 if period==8019
replace deflator=0.97 if period==8020
replace deflator=0.97 if period==8021
replace deflator=0.96 if period==8022
replace deflator=0.96 if period==8023
replace deflator=0.97 if period==8024
replace deflator=0.97 if period==8025
replace deflator=0.96 if period==8026
replace deflator=0.97 if period==8027
replace deflator=0.98 if period==8028
replace deflator=0.97 if period==8029
replace deflator=0.97 if period==8030
replace deflator=0.96 if period==8031
replace deflator=0.96 if period==8032
replace deflator=0.95 if period==8033
replace deflator=0.95 if period==8034
replace deflator=0.96 if period==8035
replace deflator=0.98 if period==8036
replace deflator=0.99 if period==8037
replace deflator=0.98 if period==8038
replace deflator=0.96 if period==8039
replace deflator=0.95 if period==8040
replace deflator=0.95 if period==8041
replace deflator=0.94 if period==8042
replace deflator=0.95 if period==8043
replace deflator=0.95 if period==8044
replace deflator=0.94 if period==8045
replace deflator=0.93 if period==8046
replace deflator=0.93 if period==8047
replace deflator=0.93 if period==8048
replace deflator=0.93 if period==8049
replace deflator=0.93 if period==8050
replace deflator=0.93 if period==8051
replace deflator=0.92 if period==8052
replace deflator=0.92 if period==8053
replace deflator=0.93 if period==8054
replace deflator=0.94 if period==8055
replace deflator=0.94 if period==8056
replace deflator=0.95 if period==8057
replace deflator=0.94 if period==8058
replace deflator=0.94 if period==8059
replace deflator=0.95 if period==8060
replace deflator=0.96 if period==8061
replace deflator=0.97 if period==8062
replace deflator=0.98 if period==8063
replace deflator=0.98 if period==8064
replace deflator=0.97 if period==8065
replace deflator=0.97 if period==8066
replace deflator=0.97 if period==8067
replace deflator=0.97 if period==8068
replace deflator=0.97 if period==8069
replace deflator=0.97 if period==8070
replace deflator=0.96 if period==8071
replace deflator=0.96 if period==8072



** deflating investment
bys period: gen defcapex=capex/deflator*0.96

*** producing median of investment
egen medianbas=median(capex) if capex>0
egen mediandef=median(defcapex) if defcapex>0


preserve 

egen maxcapex=max(defcapex) if defcapex>0
drop if defcapex==maxcapex

drop maxcapex

egen maxcapex=max(defcapex) if defcapex>0

tabstat maxcapex, stats (mean max min)
restore

*** finding unique number of firms in each period
preserve 
collapse (count) number_of_firms=firmid2, by (tsid)

tabstat number_of_firms, stats (N mean min max) by (tsid)
restore









